<?php

namespace App\Filament\Resources\CategoryDistributionChartResource\Widgets;

use App\Models\ReformProject;
use Filament\Widgets\PieChartWidget;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class CategoryDistributionChart extends PieChartWidget
{
    protected static ?string $heading = 'Reform Projects by Focus Area';
    protected static ?int $sort = 3;
    protected static ?string $maxHeight = '300px';

    protected function getData(): array
    {
        $focusAreas = ReformProject::select('focus_area', DB::raw('COUNT(*) as count'))
            ->groupBy('focus_area')
            ->orderByDesc('count')
            ->get();

        $colors = [
            '#EF4444', // red
            '#3B82F6', // blue
            '#10B981', // green
            '#F59E0B', // amber
            '#8B5CF6', // violet
            '#EC4899', // pink
            '#6EE7B7', // teal
            '#FDE68A'  // yellow
        ];

        return [
            'labels' => $focusAreas->pluck('focus_area'),
            'datasets' => [
                [
                    'label' => 'Projects',
                    'data' => $focusAreas->pluck('count'),
                    'backgroundColor' => $colors,
                    'hoverOffset' => 4,
                    'borderWidth' => 1,
                ],
            ],
        ];
    }

    protected function getType(): string
    {
        return 'pie';
    }

    // Control widget visibility with 'view reform-stats' permission
    public static function canView(): bool
    {
        $user = Auth::user();
        /** @var \App\Models\User $user */
        return $user && $user->can('view reform-stats-on-dashoard');
    }
}
