<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PollOptionResource\Pages;
use App\Filament\Resources\PollOptionResource\RelationManagers;
use App\Models\PollOption;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PollOptionResource extends Resource
{
    protected static ?string $model = PollOption::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    protected static ?string $navigationGroup = 'Public Engagement';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('text')
                    ->searchable(),

                TextColumn::make('votes')
                    ->sortable(),

                // TextColumn::make('percentage')
                //     ->getStateUsing(function ($record) {
                //         $totalVotes = $record->poll->options()->sum('votes');
                //         return $totalVotes > 0 ? round(($record->votes / $totalVotes) * 100, 1) . '%' : '0%';
                //     }),
                TextColumn::make('percentage')
                    ->getStateUsing(function ($record) {
                        return ($record->votes * 5) . '%';
                    }),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPollOptions::route('/'),
            'create' => Pages\CreatePollOption::route('/create'),
            'edit' => Pages\EditPollOption::route('/{record}/edit'),
        ];
    }
}
