<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PublicationResource\Pages;
use App\Filament\Resources\PublicationResource\RelationManagers;
use App\Models\Publication;
use Filament\Forms;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PublicationResource extends Resource
{
    protected static ?string $model = Publication::class;

    protected static ?string $navigationIcon = 'heroicon-o-book-open';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('title')->required(),
                Select::make('type')
                    ->options(['report' => 'Report', 'brief' => 'Brief'])
                    ->required(),
                Textarea::make('description')->columnSpanFull(),
                DatePicker::make('published_date')->required(),
                FileUpload::make('file_upload')
                    ->label('Upload File')
                    ->disk('public') // or your desired disk
                    ->directory('publications')
                    ->acceptedFileTypes(['application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'])
                    ->maxSize(20480) // 20MB in kilobytes
                    ->preserveFilenames()
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('title')->searchable()->sortable(),
                TextColumn::make('type')->badge(),
                TextColumn::make('published_date')->date()->sortable(),
            ])
            ->filters([
                SelectFilter::make('type')->options(['report' => 'Report', 'brief' => 'Brief']),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\ViewAction::make(),
                Tables\Actions\DeleteAction::make()->successNotification(Notification::make()->success()->title("Publication Deleted.")->body('The Publication Deleted Successfully'))
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    protected function getTableEmptyStateHeading(): ?string
    {
        return 'No publications found';
    }

    protected function getTableEmptyStateDescription(): ?string
    {
        return 'Upload your first publication to get started';
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }


    // protected function getTableRecordsPerPageSelectOptions(): array
    // {
    //     return [5, 10, 25];
    // }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPublications::route('/'),
            'create' => Pages\CreatePublication::route('/create'),
            'edit' => Pages\EditPublication::route('/{record}/edit'),
        ];
    }

    public static function getNavigationGroup(): ?string
    {
        return 'Content Management';
    }
}
