<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SiteSettingResource\Pages\EditSiteSetting;
use App\Filament\Resources\SiteSettingsResource\Pages;
use App\Filament\Resources\SiteSettingsResource\Pages\CreateSiteSettings;
use App\Filament\Resources\SiteSettingsResource\Pages\EditSiteSettings;
use App\Filament\Resources\SiteSettingsResource\RelationManagers;
use App\Models\SiteSetting;
use App\Models\SiteSettings;
use Filament\Forms;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TagsInput;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class SiteSettingsResource extends Resource
{
    protected static ?string $model = SiteSetting::class;

    protected static ?string $navigationIcon = 'heroicon-o-cog';
    public static function shouldRegisterNavigation(): bool
    {
        return true;
    }

    public static function canCreate(): bool
    {
        return false;
    }

    public static function canDelete($record): bool
    {
        return false;
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()->limit(1);
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('site_name')->label('Site Name')->required(),
                Forms\Components\FileUpload::make('logo')->label('Site Logo')
                    ->image()
                    ->directory('site-settings/site-logo')
                    ->disk('public')
                    ->visibility('public')
                    ->imageEditor(),
                Forms\Components\FileUpload::make('slider_images')
                    ->label('Homepage Slide Banner')
                    ->image()
                    ->directory('site-settings/homepage-banner')
                    ->disk('public')
                    ->maxFiles(3) // 🔒 This limits uploads to 3 images
                    ->multiple()
                    ->visibility('public')
                    ->imageEditor(),
                Forms\Components\FileUpload::make('breadcrumb')
                    ->label('Static Header(breadcrumbs)')
                    ->image()
                    ->directory('site-settings/breadcrumbs')
                    ->disk('public')
                    ->visibility('public')
                    ->imageEditor(),
                Forms\Components\FileUpload::make('about_banner')->label('About Us Banner')
                    ->image()
                    ->directory('site-settings/aboutus-banner')
                    ->disk('public')
                    ->visibility('public')
                    ->imageEditor(),
                Forms\Components\FileUpload::make('about_banner2')->label('About Us Banner 2')
                    ->image()
                    ->directory('site-settings/aboutus-banner')
                    ->disk('public')
                    ->visibility('public')
                    ->imageEditor(),
                Forms\Components\FileUpload::make('mission_banner')
                    ->label('Our Mission Banner')
                    ->image()
                    ->directory('site-settings/mission-banner')
                    ->disk('public')
                    ->visibility('public')
                    ->imageEditor(),

                TextInput::make('contact_email')->email(),
                TextInput::make('contact_phone'),
                TextInput::make('contact_address'),

                TextInput::make('facebook_link')->label('Facebook URL')->afterStateHydrated(
                    function (TextInput $component, $state) {
                        if ($state && !str_starts_with($state, 'http')) {
                            $component->state('https://' . ltrim($state, '/'));
                        }
                    }
                ),
                TextInput::make('twitter_link')->label('Twitter URL')->afterStateHydrated(
                    function (TextInput $component, $state) {
                        if ($state && !str_starts_with($state, 'http')) {
                            $component->state('https://' . ltrim($state, '/'));
                        }
                    }
                ),
                TextInput::make('linkedin_link')->label('Instagram URL')->afterStateHydrated(
                    function (TextInput $component, $state) {
                        if ($state && !str_starts_with($state, 'http')) {
                            $component->state('https://' . ltrim($state, '/'));
                        }
                    }
                ),
                // TagsInput::make('featured_reforms')
                //     ->label('Featured Reform Topics')
                //     ->placeholder('Add topics like Constitutional Reform, Justice Access'),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                ImageColumn::make('logo')->label('Logo')->circular()->disk('public'),
                TextColumn::make('site_name')->label('Site Name'),
                TextColumn::make('contact_email')->label('Email'),
                TextColumn::make('contact_phone')->label('Phone'),
                TextColumn::make('contact_address')->label('Office Address'),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSiteSettings::route('/'),
            'create' => Pages\CreateSiteSettings::route('/create'),
            'edit' => Pages\EditSiteSettings::route('/{record}/edit'),
        ];
    }

    public static function getNavigationGroup(): ?string
    {
        return 'Settings';
    }
}
