<?php

namespace App\Http\Controllers;

use App\Mail\ContactFormConfirmation;
use App\Models\ContactForm;
use App\Models\SiteSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    public function index()
    {
        $siteSettings = cache()->remember('settings', 3600, fn() => SiteSetting::first());
        return view("contact", compact("siteSettings"));
    }

    public function submit(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|min:3',
            'email' => 'required|email',
            'message' => 'required|min:10',
        ]);

        $contact = ContactForm::create($validated);

        Mail::to($contact->email)->send(new ContactFormConfirmation($contact));

        return redirect()->route('contact')->with('success', 'Thank you! Your message has been sent.');
    }
}
