<?php

namespace App\Http\Controllers;

use App\Models\News;
use App\Models\SiteSetting;
use App\Models\TeamMember;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $news = News::latest()->get();
        //  $news = News::latest()->paginate(6);
        // $settings = SiteSetting::first();
        $siteSettings = cache()->remember('settings', 3600, fn() => SiteSetting::first());
        $teamMembers = TeamMember::latest()->get();

        // Get slider images from site settings
        $sliderImages = $siteSettings->slider_images ?? [];
        // $sliderImages = json_decode($siteSettings->slider_images, true) ?? [];
        return view('home', compact('news', 'siteSettings', 'teamMembers', 'sliderImages'));
    }
}
