<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\News;
use Illuminate\Http\Request;


class NewsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $news = News::latest()->paginate(6);
        return view('news.index', compact('news'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(News $news)
    {
        $previous = News::where('id', '<', $news->id)
            ->orderByDesc('id')
            ->first();

        $next = News::where('id', '>', $news->id)
            ->orderBy('id')
            ->first();

        $latestNews = News::where('id', '!=', $news->id)
            ->latest()
            ->take(5)
            ->get();

        $categories = Category::withCount('news')
            ->orderBy('name')
            ->get();

        return view('news.show', compact(
            'news',
            'previous',
            'next',
            'latestNews',
            'categories'
        ));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
