<?php

namespace App\Http\Controllers;

use App\Models\Publication;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class PublicationController extends Controller
{
    /**
     * Display a listing of the resource.
     */

    public function index(Request $request)
    {
        $query = Publication::query();

        if ($request->filled('type')) {
            $query->where('type', $request->type);
        }

        if ($request->filled('year')) {
            $query->whereYear('published_date', $request->year);
        }

        $publications = $query->latest('published_date')->paginate(10);

        // Get distinct publication years for the filter
        $years = Publication::selectRaw('YEAR(published_date) as year')
            ->distinct()
            ->orderByDesc('year')
            ->pluck('year');

        return view('publications.index', compact('publications', 'years'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function download(Publication $publication)
    {
        // Validate file exists
        if (!$publication->file_upload || !Storage::exists($publication->file_upload)) {
            abort(404, "File not available for {$publication->title}");
        }

        // Get original filename if stored, otherwise generate
        $filename = $publication->original_filename ??
            'publication-' . $publication->id . '.pdf';

        // Force PDF download
        return Storage::download(
            $publication->file_upload,
            $filename,
            ['Content-Type' => 'application/pdf']
        );
    }
}
