<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CallForMemoranda extends Model
{
    protected $fillable = [
        'title',
        'description',
        'related_legislation',
        'start_date',
        'end_date',
        'document_path',
        'contact_email'
    ];

    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime'
    ];

    public function memoranda(): HasMany
    {
        return $this->hasMany(Memorandum::class, 'call_id');
    }

    public function call(): BelongsTo
    {
        return $this->belongsTo(CallForMemoranda::class, 'call_id');
    }
}
