<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EventRegistration extends Model
{
    protected $fillable = [
        'event_id',
        'name',
        'email',
        'organization',
        'attending_as',
        'requirements'
    ];

    public function event(): BelongsTo
    {
        return $this->belongsTo(Event::class);
    }
}
