<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class News extends Model
{
    protected $fillable = ['title', 'content', 'images', 'video_url', 'category_id', 'user_id'];

    protected $casts = [
        'images' => 'array', // Cast JSON to array
    ];


    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    public function getImageUrlAttribute()
    {
        return asset("storage/{$this->image}");
    }
}
