<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class SiteSetting extends Model implements HasMedia
{
    use InteractsWithMedia;
    protected $fillable = [
        'site_name',
        'logo',
        'slider_images',
        // 'banner',
        'breadcrumb',
        'about_banner',
        'about_banner2',
        'mission_banner',
        'contact_email',
        'contact_phone',
        'contact_address',
        'facebook_link',
        'twitter_link',
        'linkedin_link',
        'featured_reforms',
    ];

    protected $casts = [
        // 'featured_reforms' => 'array',
        'slider_images' => 'array',
    ];

    protected static function booted()
    {
        static::updated(function () {
            cache()->forget('settings');
        });
    }
}
