<?php

namespace App\Observers;

use App\Mail\NewPublicationNotification;
use App\Mail\UpdatePublicationNotification;
use App\Models\publication;
use Illuminate\Support\Facades\Mail;

class PublicationObserver
{
    /**
     * Handle the publication "created" event.
     */
    public function created(publication $publication): void
    {
        Mail::to('support@lawreform.com')
            // ->cc($publication->user->email) // Assuming the project has a 'user' relationship
            ->send(new NewPublicationNotification($publication));
    }

    /**
     * Handle the publication "updated" event.
     */
    public function updated(publication $publication): void
    {
        // Get changed fields
        $changes = $publication->getChanges();

        // Filter out timestamps
        $meaningfulChanges = array_diff_key($changes, [
            'updated_at' => true,
            'created_at' => true
        ]);

        if (!empty($meaningfulChanges)) {
            Mail::to('subscribers@example.com')
                ->send(new UpdatePublicationNotification($publication, $meaningfulChanges));
        }
    }

    /**
     * Handle the publication "deleted" event.
     */
    public function deleted(publication $publication): void
    {
        //
    }

    /**
     * Handle the publication "restored" event.
     */
    public function restored(publication $publication): void
    {
        //
    }

    /**
     * Handle the publication "force deleted" event.
     */
    public function forceDeleted(publication $publication): void
    {
        //
    }
}
