<?php

namespace App\Policies;

use App\Models\Role;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class RolePolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        if ($user->hasPermissionTo('view roles')) {
            return true;
        }
        return false;
        // return $user->hasRole('admin') && $user->hasPermissionTo('view roles');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        if ($user->hasPermissionTo('create role')) {
            return true;
        }
        return false;
        // return $user->hasRole('admin') && $user->hasPermissionTo('create role');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user): bool
    {
        if ($user->hasPermissionTo('update role')) {
            return true;
        }
        return false;
        // return $user->hasRole('admin') && $user->hasPermissionTo('update role');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user): bool
    {
        if ($user->hasPermissionTo('delete role')) {
            return true;
        }
        return false;
        // return $user->hasRole('admin') && $user->hasPermissionTo('delete role');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user): bool
    {
        return false;
    }
}
