<?php

namespace App\Providers;

use App\Models\Category;
use App\Models\Event;
use Illuminate\Support\ServiceProvider;
use App\Models\News;
use App\Models\Poll;
use App\Models\Publication;
use App\Models\ReformProject;
use App\Models\SiteSetting;
use App\Models\User;
use App\Observers\LawReformProjectObserver;
use App\Observers\NewsObserver;
use App\Observers\PublicationObserver;
use App\Policies\CategoryPolicy;
use App\Policies\EventPolicy;
use App\Policies\PermissionPolicy;
use App\Policies\PollPolicy;
use App\Policies\PublicationPolicy;
use App\Policies\ReformProjectPolicy;
use App\Policies\RolePolicy;
use App\Policies\SiteSettingPolicy;
use App\Policies\UserPolicy;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\View;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Gate::before(function ($user, $ability) {
        //     return $user->hasRole('admin') ? true : null;
        // });
        Gate::policy(User::class, UserPolicy::class);
        Gate::policy(SiteSetting::class, SiteSettingPolicy::class);
        Gate::policy(Publication::class, PublicationPolicy::class);
        Gate::policy(ReformProject::class, ReformProjectPolicy::class);
        Gate::policy(Category::class, CategoryPolicy::class);
        Gate::policy(Role::class, RolePolicy::class);
        Gate::policy(Permission::class, PermissionPolicy::class);
        Gate::policy(Poll::class, PollPolicy::class);
        Gate::policy(Event::class, EventPolicy::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // View::share('siteSettings', SiteSetting::first());
        View::composer('*', function ($view) {
            $view->with('siteSettings', SiteSetting::first() ?? new \App\Models\SiteSetting);
        });
        News::observe(NewsObserver::class);
        ReformProject::observe(LawReformProjectObserver::class);
        Publication::observe(PublicationObserver::class);
    }
}
