<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\LawReform>
 */
class LawReformFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {

        return [
            'title' => fake()->sentence(),
            'description' => fake()->paragraphs(3, true),
            'document_path' => 'documents/' . fake()->uuid() . '.pdf',
            'effective_date' => fake()->date(),
            'is_active' => fake()->boolean(80),
        ];
    }
}
