<?php

namespace Database\Factories;

use App\Models\ReformProject;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ReformProject>
 */
class ReformProjectFactory extends Factory
{
    protected $model = ReformProject::class;

    public function definition(): array
    {
        $focusAreas = ['Gender', 'Criminal Justice', 'Education', 'Health'];
        // $statuses = ['Planning', 'In Progress', 'Completed'];

        return [
            'title' => $this->faker->sentence(4),
            'description' => $this->faker->paragraph(),
            // 'focus_area' => $this->faker->randomElement($focusAreas),
            // 'status' => $this->faker->randomElement(['Planning', 'In Progress', 'Completed']),
            'start_date' => $this->faker->date(),
            'end_date' => $this->faker->date(),
            'progress_report' => null, // File can be uploaded manually
            'outcomes' => $this->faker->sentence(6),
            'user_id' => 1
        ];
    }
}
