<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reform_projects', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description');
            $table->enum('focus_area', ['Gender', 'Criminal Justice', 'Constitutional', 'Others']);
            // $table->enum('status', ['Planned', 'Ongoing', 'Completed']);
            $table->enum('status', ['Planning', 'In Progress', 'Completed']);
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->string('progress_report')->nullable();
            $table->text('outcomes')->nullable();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reform_projects');
    }
};
