<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description');
            $table->string('event_type');
            $table->dateTime('start_date');
            $table->dateTime('end_date');
            $table->string('location');
            $table->text('location_details')->nullable();
            $table->integer('supporters')->default(0);
            $table->integer('max_attendees')->default(0);
            $table->string('organizer')->nullable();
            $table->string('organizer_contact')->nullable();
            $table->string('registration_link')->nullable();
            $table->json('agenda')->nullable();
            $table->json('speakers')->nullable();
            $table->json('gallery')->nullable();
            $table->boolean('is_published')->default(false);
            $table->string('image_path')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('events');
    }
};
