<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('call_for_memoranda', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description');
            $table->string('related_legislation');
            $table->dateTime('start_date');
            $table->dateTime('end_date');
            $table->string('document_path')->nullable();
            $table->string('contact_email');
            $table->foreignId('call_id')->nullable()->constrained('call_for_memoranda')->nullOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('call_for_memorandas');
    }
};
