<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Admin Role
        $adminRole = Role::firstOrCreate(['name' => 'admin']);

        // Create Admin User
        $admin = User::firstOrCreate(
            ['email' => 'admin@lawreform.com'],
            [
                'name' => 'System Admin',
                'password' => Hash::make('admin@12345'),

            ]
        );

        // Assign Role
        $admin->assignRole($adminRole);

        // Create and assign all permissions
        $permissions = [
            // User permissions
            'view users',
            'create users',
            'update users',
            'delete users',

            // Role permissions
            'view roles',
            'create role',
            'update role',
            'delete role',

            // Permission permissions
            'view permissions',

            // Publication permissions
            'view publications',
            'create publication',
            'update publication',
            'delete publication',

            // Reform project permissions
            'view reforms',
            'create reform',
            'update reform',
            'delete reform',

            // Site setting permissions
            'view site-setting',
            'update site-settings',

            // Team member permissions
            'view team-members',
            'create team-member',
            'update team-member',
            'delete team-member',

            // News permissions
            'view news',
            'create news',
            'update news',
            'delete news',

            // Category permissions
            'view categories',
            'create category',
            'update category',
            'delete category',

            // Contact permissions
            'view contact-requests',
            'delete contact-request',


            'view event',
            'create event',
            'update event',
            'delete event',

            'view event-registeration',
            'update event-registeration',
            'delete event-registeration',

            'view feedback',
            'update feedback',
            'delete feedback',

            'view influential-poll',
            'update influential-poll',


            'view memorandum',
            'update memorandum',
            'delete memorandum',

            'view poll-option',
            'update poll-option',
            'delete poll-option',

            'view poll',
            'create poll',
            'update poll',
            'delete poll',

            'view reform-stats-on-dashoard',
            'view publication-stats-on-dashboard',
            'view reform-stats-on-dashoard',
            'view user-stats-on-dashboard',
            'view news-stats-on-dashboard',
            'view active-reform-stats-on-dashboard',

        ];

        foreach ($permissions as $permissionName) {
            $permission = Permission::firstOrCreate(['name' => $permissionName]);
            $adminRole->givePermissionTo($permission);
        }
    }
}
