<!DOCTYPE html>
<html>

<head>
    <style>
        .email-container {
            max-width: 650px;
            margin: 0 auto;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .header {
            background-color: #1a365d;
            padding: 25px;
            color: white;
            text-align: center;
            border-bottom: 4px solid #c5a267;
        }

        .badge {
            background: #c5a267;
            color: #1a365d;
            padding: 6px 20px;
            border-radius: 20px;
            font-weight: 700;
            font-size: 0.9em;
            display: inline-block;
            margin-bottom: 15px;
        }

        .content {
            padding: 30px;
            background-color: #f8fafc;
        }

        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            margin-bottom: 25px;
        }

        .field-group {
            display: flex;
            padding: 18px 25px;
            border-bottom: 1px solid #edf2f7;
        }

        .field-label {
            flex: 0 0 180px;
            color: #2d3748;
            font-weight: 600;
            font-size: 0.95em;
        }

        .field-value {
            flex: 1;
            color: #4a5568;
            line-height: 1.6;
        }

        .divider {
            height: 1px;
            background: linear-gradient(to right, transparent, #e2e8f0, transparent);
            margin: 25px 0;
        }

        .footer {
            text-align: center;
            padding: 25px;
            color: #718096;
            font-size: 0.9em;
            background: #f8fafc;
            border-top: 1px solid #e2e8f0;
        }

        .download-btn {
            display: inline-block;
            background: #2b6cb0;
            color: white;
            text-decoration: none;
            padding: 14px 30px;
            border-radius: 6px;
            font-weight: 600;
            margin: 20px 0;
            transition: all 0.3s ease;
        }

        .download-btn:hover {
            background: #1a5187;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .publication-type {
            display: inline-block;
            padding: 5px 15px;
            background: #ebf8ff;
            border-radius: 4px;
            color: #2b6cb0;
            font-weight: 600;
        }
    </style>
</head>

<body>
    <div class="email-container">
        <div class="header">
            <div class="badge">NEW PUBLICATION</div>
            <h1 style="margin: 10px 0 5px; font-weight: 400; font-size: 1.8em;">{{ $publication->title }}</h1>
            <p style="margin: 0; opacity: 0.9; font-size: 1.1em;">Now available in our digital repository</p>
        </div>

        <div class="content">
            <div class="card">
                <div class="field-group">
                    <div class="field-label">Publication Type</div>
                    <div class="field-value">
                        <span class="publication-type">{{ ucfirst($publication->type) }}</span>
                    </div>
                </div>

                <div class="field-group">
                    <div class="field-label">Published Date</div>
                    <div class="field-value">
                        {{ \Carbon\Carbon::parse($publication->published_date)->format('F j, Y') }}
                    </div>
                </div>

                <div class="field-group">
                    <div class="field-label">Description</div>
                    <div class="field-value">
                        {{ $publication->description }}
                    </div>
                </div>

                <div class="field-group" style="border-bottom: none;">
                    <div class="field-label">Document Access</div>
                    <div class="field-value">
                        <a href="{{ asset('storage/' . $publication->file_upload) }}" class="download-btn">
                            Download Publication
                        </a>
                        <p style="margin: 8px 0 0; font-size: 0.9em; color: #718096;">
                            PDF Document • {{ round(filesize(storage_path('app/public/' . $publication->file_upload)) / 1024 / 1024, 2) }} MB
                        </p>
                    </div>
                </div>
            </div>

            <div style="background-color: #fffaf0; padding: 25px; border-radius: 8px; border-left: 4px solid #dd6b20;">
                <h3 style="margin-top: 0; color: #dd6b20;">About This Publication</h3>
                <p>This {{ $publication->type }} has been formally added to our research repository and is now accessible to authorized users. You may reference this publication using the identifier:</p>
                <p style="background: white; padding: 12px; border-radius: 6px; font-family: monospace; word-break: break-all;">
                    PUB-{{ strtoupper(substr($publication->type, 0, 3)) }}-{{ $publication->id }}-{{ \Carbon\Carbon::parse($publication->published_date)->format('Y') }}
                </p>
            </div>

            <div class="divider"></div>

            <p style="text-align: center; margin-bottom: 25px;">
                <a href="{{ route('publications.index') }}" style="color: #2b6cb0; text-decoration: none; font-weight: 600;">
                    Browse All Publications →
                </a>
            </p>
        </div>

        <div class="footer">
            <p>© {{ date('Y') }} Law Reform Commission. All rights reserved.<br>
                This is an automated notification. To unsubscribe from publication alerts, <a href="#" style="color: #2b6cb0;">update your preferences</a>.<br>
                Questions? Contact <a href="mailto:support@lawreform.org" style="color: #2b6cb0;">support@lawreform.org</a></p>
        </div>
    </div>
</body>

</html>