<!DOCTYPE html>
<html>

<head>
    <style>
        .email-container {
            max-width: 650px;
            margin: 0 auto;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .header {
            background-color: #1a365d;
            padding: 25px;
            color: white;
            text-align: center;
            border-bottom: 4px solid #c5a267;
            position: relative;
        }

        .update-ribbon {
            position: absolute;
            top: 20px;
            right: -30px;
            background: #c5a267;
            color: #1a365d;
            padding: 8px 40px;
            transform: rotate(45deg);
            font-weight: 700;
            font-size: 0.9em;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }

        .content {
            padding: 30px;
            background-color: #f8fafc;
        }

        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            margin-bottom: 25px;
        }

        .field-group {
            display: flex;
            padding: 18px 25px;
            border-bottom: 1px solid #edf2f7;
        }

        .field-label {
            flex: 0 0 180px;
            color: #2d3748;
            font-weight: 600;
            font-size: 0.95em;
        }

        .field-value {
            flex: 1;
            color: #4a5568;
            line-height: 1.6;
        }

        .updated-field {
            background-color: #fffaf0;
            padding: 3px 6px;
            border-radius: 4px;
            border-left: 3px solid #dd6b20;
        }

        .changes-summary {
            background-color: #f8f9fa;
            padding: 25px;
            border-radius: 8px;
            border-left: 4px solid #2b6cb0;
            margin-bottom: 25px;
        }

        .footer {
            text-align: center;
            padding: 25px;
            color: #718096;
            font-size: 0.9em;
            background: #f8fafc;
            border-top: 1px solid #e2e8f0;
        }

        .download-btn {
            display: inline-block;
            background: #2b6cb0;
            color: white;
            text-decoration: none;
            padding: 14px 30px;
            border-radius: 6px;
            font-weight: 600;
            margin: 10px 0;
            transition: all 0.3s ease;
        }

        .download-btn:hover {
            background: #1a5187;
        }

        .publication-type {
            display: inline-block;
            padding: 5px 15px;
            background: #ebf8ff;
            border-radius: 4px;
            color: #2b6cb0;
            font-weight: 600;
        }

        .version-badge {
            background: #e53e3e;
            color: white;
            padding: 3px 10px;
            border-radius: 4px;
            font-size: 0.8em;
            margin-left: 10px;
            vertical-align: middle;
        }

        .divider {
            height: 1px;
            background: linear-gradient(to right, transparent, #e2e8f0, transparent);
            margin: 20px 0;
        }
    </style>
</head>

<body>
    <div class="email-container">
        <div class="header">
            <div class="update-ribbon">UPDATED</div>
            <h1 style="margin: 10px 0 5px; font-weight: 400; font-size: 1.8em;">Publication Revised: {{ $publication->title }}</h1>
            <p style="margin: 0; opacity: 0.9; font-size: 1.1em;">Important updates to this research document</p>
        </div>

        <div class="content">
            <div class="changes-summary">
                <h3 style="margin-top: 0; color: #2b6cb0;">Update Notification</h3>
                <p>The publication "<strong>{{ $publication->title }}</strong>" has been revised with important updates. Please review the changes below.</p>
                <p style="margin-bottom: 0;"><strong>Reason for update:</strong> Content enhancements and corrections</p>
            </div>

            <div class="card">
                <div class="field-group">
                    <div class="field-label">Publication Type</div>
                    <div class="field-value">
                        <span class="publication-type">
                            {{ ucfirst($publication->type) }}
                            <span class="version-badge">Updated</span>
                        </span>
                    </div>
                </div>

                <div class="field-group">
                    <div class="field-label">Title</div>
                    <div class="field-value">
                        <span class="updated-field">{{ $publication->title }}</span>
                    </div>
                </div>

                <div class="field-group">
                    <div class="field-label">Published Date</div>
                    <div class="field-value">
                        <span class="updated-field">
                            {{ \Carbon\Carbon::parse($publication->published_date)->format('F j, Y') }}
                        </span>
                    </div>
                </div>

                <div class="field-group">
                    <div class="field-label">Description</div>
                    <div class="field-value">
                        <span class="updated-field">
                            {{ $publication->description }}
                        </span>
                    </div>
                </div>

                <div class="field-group" style="border-bottom: none;">
                    <div class="field-label">Document Access</div>
                    <div class="field-value">
                        <a href="{{ asset('storage/' . $publication->file_upload) }}" class="download-btn">
                            Download Updated Version
                        </a>
                        <p style="margin: 8px 0 0; font-size: 0.9em; color: #718096;">
                            <strong style="color: #e53e3e;">NEW REVISION:</strong>
                            PDF Document • {{ round(filesize(storage_path('app/public/' . $publication->file_upload)) / 1024 / 1024, 2) }} MB
                            <br>Version {{ $publication->version ?? '2.0' }}
                        </p>
                    </div>
                </div>
            </div>

            <div class="divider"></div>



            <p style="text-align: center; margin-top: 5px;">
                <a href="{{ route('publications.index') }}" style="color: #718096; text-decoration: none; font-size: 0.9em;">
                    Browse All Publications
                </a>
            </p>
        </div>

        <div class="footer">
            <p>© {{ date('Y') }} Law Reform Commission. All rights reserved.<br>
                This revision notification was automatically generated.<br>
                Contact <a href="mailto:research@lawreform.org" style="color: #2b6cb0;">research@lawreform.org</a> for content inquiries</p>
        </div>
    </div>
</body>

</html>