@extends('layouts.app')

@section('content')
<div class="banner-header valign bg-img bg-fixed" data-overlay-dark="6" data-background="{{ asset('storage/'.$reform->image) }}">
    <div class="container">
        <div class="row">
            <div class="col-md-12 caption mt-60 text-center">
                <h6>
                    <div class="icon"><i class="flaticon-courthouse"></i></div> Law Reform
                </h6>
                <h1>{{ $reform->title }}</h1>
            </div>
        </div>
    </div>
</div>

<section class="section-padding">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h3>Description</h3>
                <p>{{ $reform->description }}</p>

                @if($reform->document_path)
                <div class="mt-40">
                    <a href="{{ asset('storage/'.$reform->document_path) }}"
                        class="butn butn-dark"
                        download>
                        <span>Download Document</span>
                    </a>
                </div>
                @endif
            </div>
            <div class="col-md-4">
                <div class="sidebar">
                    <div class="item">
                        <h6>Effective Date</h6>
                        <p>{{ $reform->effective_date->format('F j, Y') }}</p>
                    </div>
                    <div class="item">
                        <h6>Status</h6>
                        <p>{{ $reform->is_active ? 'Active' : 'Inactive' }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection