@extends('layouts.app')

@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
    :root {
        --primary: rgb(129, 94, 6);
        --secondary: rgb(129, 94, 6);
        --accent: rgb(129, 94, 6);
        --light: #f8f9fa;
        --dark: #212529;
    }

    .public-engagement {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f5f7fa;
        color: #333;
    }

    .hero-section {
        background: linear-gradient(rgb(129, 94, 6), rgb(129, 94, 6)), url('https://images.unsplash.com/photo-1507679799987-c73779587ccf?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1742&q=80');
        background-size: cover;
        background-position: center;
        color: white;
        padding: 80px 0;
    }

    .section-title {
        position: relative;
        padding-bottom: 15px;
        margin-bottom: 30px;
        text-align: center;
    }

    .section-title:after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 80px;
        height: 4px;
        background: var(--secondary);
    }

    .card {
        border: none;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        transition: transform 0.3s, box-shadow 0.3s;
        margin-bottom: 25px;
        overflow: hidden;
    }

    .card:hover {
        transform: translateY(-10px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
    }

    .card-header {
        background: var(--primary);
        color: white;
        font-weight: 600;
        padding: 15px 20px;
    }

    .form-section {
        background: white;
        border-radius: 10px;
        padding: 30px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }

    .btn-primary {
        background: var(--primary);
        border: none;
        padding: 10px 25px;
        font-weight: 600;
        transition: all 0.3s;
    }

    .btn-primary:hover {
        background: var(--accent);
        transform: translateY(-2px);
    }

    .poll-card .progress {
        height: 25px;
        border-radius: 5px;
        margin: 10px 0;
    }

    .event-card {
        border-left: 4px solid var(--secondary);
        transition: all 0.3s;
    }

    .event-card:hover {
        border-left: 8px solid var(--accent);
    }

    .stat-card {
        text-align: center;
        padding: 20px;
        border-radius: 10px;
        color: white;
    }

    .stat-card i {
        font-size: 2.5rem;
        margin-bottom: 15px;
    }

    .stat-1 {
        background: linear-gradient(135deg, #0d3e69, #1a5a92);
    }

    .stat-2 {
        background: linear-gradient(135deg, #b8860b, #d4af37);
    }

    .stat-3 {
        background: linear-gradient(135deg, #1a5a92, #2a75c2);
    }

    .engagement-tabs .nav-link {
        color: var(--primary);
        font-weight: 500;
        border: none;
        border-bottom: 3px solid transparent;
        padding: 12px 25px;
    }

    .engagement-tabs .nav-link.active {
        background: none;
        color: var(--primary);
        border-bottom: 3px solid var(--secondary);
    }

    .feature-icon {
        width: 70px;
        height: 70px;
        background: rgba(13, 62, 105, 0.1);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 20px;
        font-size: 30px;
        color: var(--primary);
    }

    .testimonial-card {
        background: white;
        border-radius: 10px;
        padding: 25px;
        position: relative;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }

    .step-number {
        width: 40px;
        height: 40px;
        background: var(--primary);
        color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        margin-right: 15px;
    }

    @media (max-width: 768px) {
        .hero-section {
            padding: 50px 0;
        }

        .section-title {
            font-size: 1.8rem;
        }
    }

    .progress-bar {
        background-color: var(--primary);
    }
</style>

<div class="public-engagement">
    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container text-center">
            <h1 class="display-4 fw-bold mb-4">Public Engagement Portal</h1>
            <p class="lead mb-5" style="color:#f5f7fa">Your voice matters in shaping the laws of Lagos State. Participate in our democratic processes and contribute to legal reforms.</p>
            <div class="d-flex justify-content-center flex-wrap gap-3">
                <div class="btn btn-light btn-lg px-4 py-2">
                    <i class="fas fa-comment me-2"></i>Give Feedback
                </div>
                <div class="btn btn-outline-light btn-lg px-4 py-2">
                    <i class="fas fa-chart-bar me-2"></i>Vote in Polls
                </div>
                <div class="btn btn-outline-light btn-lg px-4 py-2">
                    <i class="fas fa-calendar me-2"></i>View Events
                </div>
            </div>
        </div>
    </section>



    {{-- Global Messages Section --}}
    <section class="container mt-4">
        @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert" style="color:green">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>Please fix these issues:</strong>
            <ul>
                @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif
    </section>

    <!-- Stats Section -->
    <section class="py-5">
        <div class="container">
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="stat-card stat-1">
                        <i class="fas fa-comments"></i>
                        <h3>{{ $feedbackCount }}</h3>
                        <p>Public Feedback Submissions</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card stat-2">
                        <i class="fas fa-users"></i>
                        <h3>{{ $usersCount }}</h3>
                        <p>Citizens Engaged</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card stat-3">
                        <i class="fas fa-gavel"></i>
                        <h3>{{ $reformsCount }}</h3>
                        <p>Laws Influenced by Public Input</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Engagement Features -->
    <section class="py-5 bg-light">
        <div class="container">
            <h2 class="section-title">How You Can Participate</h2>
            <div class="row g-4">
                <div class="col-lg-3 col-md-6">
                    <div class="text-center p-4">
                        <div class="feature-icon">
                            <i class="fas fa-edit"></i>
                        </div>
                        <h4>Submit Feedback</h4>
                        <p>Share your thoughts on existing laws or suggest new legislation</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="text-center p-4">
                        <div class="feature-icon">
                            <i class="fas fa-file-alt"></i>
                        </div>
                        <h4>Call for Memoranda</h4>
                        <p>Submit formal proposals for legal reforms</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="text-center p-4">
                        <div class="feature-icon">
                            <i class="fas fa-poll"></i>
                        </div>
                        <h4>Participate in Polls</h4>
                        <p>Vote on important legal issues and reforms</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="text-center p-4">
                        <div class="feature-icon">
                            <i class="fas fa-calendar-check"></i>
                        </div>
                        <h4>Attend Events</h4>
                        <p>Join public hearings and stakeholder forums</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Engagement Process -->
    <section class="py-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-5 mb-lg-0">
                    <h2 class="section-title text-start">How Public Input Shapes Laws</h2>
                    <p class="mb-4">Your participation is a crucial part of our democratic process. Here's how your input makes a difference:</p>

                    <div class="d-flex align-items-start mb-4">
                        <div class="step-number">1</div>
                        <div>
                            <h5>Submission</h5>
                            <p>Citizens provide feedback through various channels</p>
                        </div>
                    </div>

                    <div class="d-flex align-items-start mb-4">
                        <div class="step-number">2</div>
                        <div>
                            <h5>Review</h5>
                            <p>Our legal experts analyze all submissions and identify key themes</p>
                        </div>
                    </div>

                    <div class="d-flex align-items-start mb-4">
                        <div class="step-number">3</div>
                        <div>
                            <h5>Integration</h5>
                            <p>Public input is incorporated into draft legislation</p>
                        </div>
                    </div>

                    <div class="d-flex align-items-start">
                        <div class="step-number">4</div>
                        <div>
                            <h5>Enactment</h5>
                            <p>Improved laws are passed, reflecting the will of the people</p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <img src="https://images.unsplash.com/photo-1589829545856-d10d557cf95f?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1470&q=80"
                        alt="Legal Process" class="img-fluid rounded shadow">
                </div>
            </div>
        </div>
    </section>

    <!-- Engagement Tabs -->
    <section id="engagement" class="py-5 bg-light">
        <div class="container">
            <h2 class="section-title">Engage With Us</h2>

            <ul class="nav nav-tabs engagement-tabs mb-4 justify-content-center" id="engagementTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="feedback-tab" data-bs-toggle="tab" data-bs-target="#feedback" type="button" role="tab">
                        <i class="fas fa-comment me-2"></i>Feedback
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="memoranda-tab" data-bs-toggle="tab" data-bs-target="#memoranda" type="button" role="tab">
                        <i class="fas fa-file-alt me-2"></i>Memoranda
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="polls-tab" data-bs-toggle="tab" data-bs-target="#polls" type="button" role="tab">
                        <i class="fas fa-poll me-2"></i>Polls
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="events-tab" data-bs-toggle="tab" data-bs-target="#events" type="button" role="tab">
                        <i class="fas fa-calendar me-2"></i>Events
                    </button>
                </li>
            </ul>

            <div class="tab-content" id="engagementTabContent">
                <!-- Feedback Tab -->
                <div class="tab-pane fade show active" id="feedback" role="tabpanel">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-section">
                                <h3 class="mb-4">Submit Your Feedback</h3>
                                <p>Help us improve Lagos State laws by sharing your thoughts and suggestions.</p>

                                <form action="{{ route('public.feedback.submit') }}" method="POST">
                                    <input type="hidden" name="active_tab" value="feedback">
                                    @csrf
                                    <div class="mb-3">
                                        <label class="form-label">Full Name</label>
                                        <input type="text" name="name" class="form-control" placeholder="Enter your name" required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Email Address</label>
                                        <input type="email" name="email" class="form-control" placeholder="Enter your email" required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Subject</label>
                                        <input type="text" name="subject" class="form-control" placeholder="Feedback subject" required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Category</label>
                                        <select name="category" class="form-select" required>
                                            <option value="" selected disabled>Select a category</option>
                                            <option value="Existing Law Review">Existing Law Review</option>
                                            <option value="New Law Proposal">New Law Proposal</option>
                                            <option value="Implementation Issues">Implementation Issues</option>
                                            <option value="Other">Other</option>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Your Feedback</label>
                                        <textarea name="message" class="form-control" rows="5" placeholder="Share your thoughts..." required></textarea>
                                    </div>

                                    <button type="submit" class="btn btn-primary">Submit Feedback</button>
                                </form>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-header">
                                    <i class="fas fa-lightbulb me-2"></i>Recent Feedback Topics
                                </div>
                                <div class="card-body">
                                    <div class="list-group">
                                        @foreach($recentTopics as $topic)
                                        <a href="#" class="list-group-item list-group-item-action">
                                            <div class="d-flex w-100 justify-content-between">
                                                <h6 class="mb-1">{{ $topic->subject }}</h6>
                                                <small>{{ $topic->created_at->diffForHumans() }}</small>
                                            </div>
                                            <small class="text-muted">{{ $topic->category }}</small>
                                        </a>
                                        @endforeach
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header">
                                    <i class="fas fa-check-circle me-2"></i>Impact of Public Feedback
                                </div>
                                <div class="card-body">
                                    <p>Public feedback has directly contributed to:</p>
                                    <ul>
                                        <li>{{ $newLawsCount }} new laws enacted in the last 2 years</li>
                                        <li>{{ $amendmentsCount }} amendments to existing legislation</li>
                                        <li>Simplification of {{ $simplifiedCount }} legal processes</li>
                                    </ul>
                                    <p class="mb-0">Your input makes a real difference in shaping Lagos State's legal framework.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Memoranda Tab -->
                <div class="tab-pane fade" id="memoranda" role="tabpanel">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-section">
                                <h3 class="mb-4">Submit a Memorandum</h3>
                                <p>Formally propose legal reforms or provide detailed analysis on specific legislation.</p>

                                <form action="{{ route('public.memorandum.submit') }}" method="POST" enctype="multipart/form-data">
                                    <input type="hidden" name="active_tab" value="memoranda">
                                    @csrf
                                    <div class="mb-3">
                                        <label class="form-label">Full Name/Organization</label>
                                        <input type="text" name="name" class="form-control" placeholder="Enter your name or organization" required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Email Address</label>
                                        <input type="email" name="email" class="form-control" placeholder="Enter your email" required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Memorandum Title</label>
                                        <input type="text" name="title" class="form-control" placeholder="Enter memorandum title" required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Related Legislation</label>
                                        <select name="legislation" class="form-select" required>
                                            <option value="" selected disabled>Select related law</option>
                                            <option value="Environmental Protection Law">Environmental Protection Law</option>
                                            <option value="Business Regulation Act">Business Regulation Act</option>
                                            <option value="Tenant Protection Act">Tenant Protection Act</option>
                                            <option value="Digital Rights Bill">Digital Rights Bill</option>
                                            <option value="Other">Other</option>
                                        </select>
                                    </div>

                                    <div class="mb-4">
                                        <label for="deadline" class="block text-sm font-medium text-gray-700">
                                            Submission Deadline
                                        </label>
                                        <input type="date" name="deadline" id="deadline"
                                            class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                            min="{{ now()->addDay()->format('Y-m-d') }}" required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Memorandum Document</label>
                                        <input type="file" name="document" class="form-control" accept=".pdf,.doc,.docx" required>
                                        <div class="form-text">Upload PDF, DOC, or DOCX file (max 5MB)</div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Executive Summary</label>
                                        <textarea name="summary" class="form-control" rows="4" placeholder="Brief summary of your memorandum" required></textarea>
                                    </div>

                                    <button type="submit" class="btn btn-primary">Submit Memorandum</button>
                                </form>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-header d-flex align-items-center">
                                    <i class="fas fa-list me-2"></i>Active Calls for Memoranda
                                </div>
                                <div class="card-body">
                                    <div class="list-group">
                                        @forelse($activeCalls as $call)
                                        <a href="#" class="list-group-item list-group-item-action">
                                            <div class="d-flex w-100 justify-content-between">
                                                <h6 class="mb-1">{{ $call['title'] }}</h6>
                                                <span class="badge bg-{{ $call['status_color'] }}">{{ $call['status'] }}</span>
                                            </div>



                                            <!-- Countdown Timer Section -->
                                            <div class="d-flex align-items-center mt-2">
                                                <i class="fas fa-clock me-2 text-primary"></i>
                                                <div>
                                                    <div class="small text-muted">Time expires on:</div>
                                                    <div class="countdown-timer"
                                                        data-deadline="{{ $call['deadline_iso'] }}"
                                                        data-fallback="{{ $call['deadline_formatted'] }}"
                                                        data-expired-text="Deadline passed">
                                                        <!-- Fallback content -->
                                                        <span class="text-muted">{{ $call['deadline_formatted'] }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <p class="mb-1 small">{{ $call['description'] }}</p>
                                        </a>
                                        @empty
                                        <div class="list-group-item">
                                            <p class="mb-0 text-center text-muted">No active calls at the moment</p>
                                        </div>
                                        @endforelse
                                    </div>
                                </div>
                            </div>

                            <div class="card mt-4">
                                <div class="card-header d-flex align-items-center">
                                    <i class="fas fa-book me-2"></i>Memoranda Guidelines
                                </div>
                                <div class="card-body">
                                    <p>For your memorandum to be considered, please ensure:</p>
                                    <ul class="mb-3">
                                        <li>Clearly state the issue and proposed solution</li>
                                        <li>Reference relevant existing legislation</li>
                                        <li>Include data or evidence supporting your proposal</li>
                                        <li>Limit to 20 pages (excluding appendices)</li>
                                        <li>Submit before the deadline</li>
                                    </ul>
                                    <div class="alert alert-info mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        All memoranda will be reviewed by our legal team and may be published on our website.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Polls Tab -->
                <div class="tab-pane fade" id="polls" role="tabpanel">
                    <div class="row">
                        <!-- Left Column -->
                        <div class="col-12 col-lg-8">
                            @if($currentPoll)
                            <div class="card mb-4">
                                <div class="card-header text-white">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h4 class="mb-0">Current Public Poll</h4>
                                        <div class="badge bg-white text-danger">
                                            <i class="fas fa-clock me-1"></i>
                                            <span id="poll-countdown" data-end="{{ $currentPoll->end_date->toIsoString() }}">
                                                {{ $currentPoll->end_date->diffForHumans() }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <h5 class="text-truncate" style="max-width: 100%;">{{ $currentPoll->title }}</h5>
                                    <p class="text-muted">{{ $currentPoll->description }}</p>

                                    <form action="{{ route('public.poll.vote', $currentPoll->id) }}" method="POST" class="mt-4">
                                        <input type="hidden" name="active_tab" value="polls">
                                        @csrf
                                        @foreach($currentPoll->options as $option)
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="radio" name="option"
                                                id="option{{ $option->id }}" value="{{ $option->id }}" required>
                                            <label class="form-check-label fw-bold" for="option{{ $option->id }}"
                                                style="word-break: break-word;">
                                                {{ $option->text }}
                                            </label>
                                        </div>
                                        @endforeach

                                        <button type="submit" class="btn btn-primary btn-lg mt-3">
                                            <i class="fas fa-check-circle me-2"></i>Submit Vote
                                        </button>
                                    </form>
                                </div>
                                <div class="card-footer text-muted">
                                    <div class="d-flex justify-content-between flex-wrap">
                                        <span>Total Votes: {{ $currentPoll->total_votes }}</span>
                                        <span class="badge bg-{{ $currentPoll->end_date->isPast() ? 'danger' : 'success' }}">
                                            {{ $currentPoll->end_date->format('M j, Y g:i A') }}
                                        </span>
                                        <!-- <span>Ends: {{ $currentPoll->end_date->format('M j, Y g:i A') }}</span> -->
                                    </div>
                                </div>
                            </div>
                            @else
                            <div class="alert alert-info">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-info-circle fa-2x me-3"></i>
                                    <div>
                                        <h5 class="mb-1">Currently there are no active polls</h5>
                                        <p class="mb-0">Check back soon for new polls on upcoming legislation</p>
                                    </div>
                                </div>
                            </div>
                            @endif

                            @if($recentPolls->count() > 0)
                            <h4 class="mt-5 mb-3 border-bottom pb-2">Recent Poll Results</h4>
                            <div class="row">
                                @foreach($recentPolls as $poll)
                                <div class="col-12 col-md-6 mb-4">
                                    <div class="card poll-card h-100">
                                        <div class="card-header bg-light">
                                            <h5 class="mb-0 text-truncate">{{ $poll->title }}</h5>
                                            <p class="text-muted mb-0 small">{{ $poll->description }}</p>
                                        </div>
                                        <div class="card-body">
                                            @foreach($poll->options->sortByDesc('percentage') as $option)
                                            <div class="mb-3">
                                                <div class="d-flex justify-content-between mb-1">
                                                    <span class="fw-medium">{{ $option->text }}</span>
                                                    <span class="text-primary fw-bold">{{ $option->percentage }}%</span>
                                                </div>
                                                <div class="progress" style="height: 10px; min-width: 100%;">
                                                    <div class="progress-bar" role="progressbar"
                                                        style="width: {{ $option->percentage }}%; background-color: {{ $poll->options->count() > 2 ? $option->color : '#0d6efd' }};"
                                                        aria-valuenow="{{ $option->percentage }}"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100">
                                                    </div>
                                                </div>
                                                <div class="text-end small text-muted mt-1">
                                                    {{ $option->votes_count }} votes
                                                </div>
                                            </div>
                                            @endforeach
                                        </div>
                                        <div class="card-footer text-muted">
                                            <div class="d-flex justify-content-between flex-wrap">
                                                <span class="badge bg-{{ $poll->end_date->isPast() ? 'danger' : 'success' }}">
                                                    Closed: {{ $poll->end_date->format('M d, Y h:i A') }}
                                                </span>
                                                <!-- <span>Closed: {{ $poll->end_date->format('M d, Y h:i A') }}</span> -->
                                                <span>{{ $poll->total_votes }} total votes</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                            @endif
                        </div>

                        <!-- Right Column -->
                        <div class="col-12 col-lg-4 mt-4 mt-lg-0">
                            <div class="card" style="top: 20px;">
                                <div class="card-header bg-light">
                                    <i class="fas fa-info-circle me-2"></i>About Our Polls
                                </div>
                                <div class="card-body">
                                    <p>Our public opinion polls help shape the direction of legal reforms in Lagos State.</p>
                                    <div class="d-flex align-items-start mb-3">
                                        <i class="fas fa-check-circle text-success mt-1 me-2"></i>
                                        <span>Results directly inform policy decisions</span>
                                    </div>
                                    <div class="d-flex align-items-start mb-3">
                                        <i class="fas fa-users text-primary mt-1 me-2"></i>
                                        <span>Open to all Lagos residents and stakeholders</span>
                                    </div>
                                    <div class="d-flex align-items-start mb-3">
                                        <i class="fas fa-calendar-alt text-warning mt-1 me-2"></i>
                                        <span>Each poll runs for 2-4 weeks</span>
                                    </div>
                                    <div class="d-flex align-items-start mb-3">
                                        <i class="fas fa-chart-bar text-info mt-1 me-2"></i>
                                        <span>Detailed results published on our website</span>
                                    </div>
                                    <div class="alert alert-warning mt-4">
                                        <i class="fas fa-exclamation-triangle me-2"></i>
                                        <strong>Your vote matters!</strong> Participate to make your voice heard in the legislative process.
                                    </div>
                                </div>
                                <div class="alert alert-warning mt-4">
                                    <h4 class="mt-5 mb-3 border-bottom pb-2">Poll Impact</h4>
                                    @foreach($influentialPolls as $poll)
                                    <div class="d-flex align-items-start mb-3">
                                        <div class="bg-primary text-white rounded-circle p-2 me-3">
                                            <i class="fas fa-check"></i>
                                        </div>
                                        <div>
                                            <h6 class="mb-0 text-truncate">{{ $poll->title }}</h6>
                                            <small class="text-muted">{{ $poll->impact_description }}</small>
                                            <div class="mt-2">
                                                <span class="badge bg-{{ $poll->impact_level === 'high' ? 'danger' : ($poll->impact_level === 'medium' ? 'warning' : 'success') }}">
                                                    Impact: {{ ucfirst($poll->impact_level) }}
                                                </span>
                                                @if($poll->result)
                                                <span class="badge bg-info ms-1">
                                                    Result: {{ $poll->result }}% support
                                                </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>

                        </div>
                    </div>
                </div>



                <!-- Events Tab -->
                <div class="tab-pane fade" id="events" role="tabpanel">
                    <div class="row">
                        <div class="col-lg-8">
                            @if($upcomingEvents->count() > 0)
                            <div class="card mb-4">
                                <div class="card-header text-white">
                                    <h4 class="mb-0">Upcoming Events</h4>
                                </div>
                                <div class="card-body">
                                    @foreach($upcomingEvents as $event)
                                    <div class="event-card p-3 mb-3">
                                        <div class="d-flex justify-content-between">
                                            <h5>{{ $event->title }}</h5>
                                            <span class="badge bg-{{ $event->supporters > 50 ? 'warning' : 'success' }}">
                                                {{ $event->supporters > 50 ? 'Limited Space' : 'Available' }}
                                            </span>
                                        </div>
                                        <p class="mb-1">
                                            <i class="far fa-calendar me-2"></i>
                                            <!-- {{ $event->start_date->format('M d, Y h:i A') }} -->
                                            @if($event->start_date->isSameDay($event->end_date))
                                            {{ $event->start_date->format('M d, Y') }} •
                                            {{ $event->start_date->format('h:i A') }} - {{ $event->end_date->format('h:i A') }}
                                            @else
                                            {{ $event->start_date->format('M d, Y') }} - {{ $event->end_date->format('M d, Y') }}
                                            @endif
                                        </p>
                                        <p class="mb-2">
                                            <i class="fas fa-map-marker-alt me-2"></i>
                                            {{ $event->location }}
                                        </p>
                                        <p>{{ $event->description }}</p>
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <span class="text-muted">
                                                    <i class="fas fa-users me-1"></i>
                                                    {{ $event->supporters }} sponsors
                                                </span>
                                            </div>
                                            <div>
                                                <!-- <a href="#" class="btn btn-sm btn-outline-primary me-2">Details</a> -->
                                                <a href="{{ route('public.event.details', $event) }}"
                                                    class="btn btn-sm btn-outline-primary me-2">
                                                    Details
                                                </a>
                                                <!-- <button class="btn btn-sm btn-primary support-event"
                                                    data-event-id="{{ $event->id }}">
                                                    Support
                                                </button> -->
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            @else
                            <div class="alert alert-info">
                                Currently there are no upcoming events. Please check back later.
                            </div>
                            @endif
                        </div>

                        <div class="col-lg-4">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <i class="fas fa-calendar-plus me-2"></i>Event Registration
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('public.event.register') }}" method="POST">
                                        <input type="hidden" name="active_tab" value="events">
                                        @csrf
                                        <div class="mb-3">
                                            <label class="form-label">Select Event</label>
                                            <select name="event_id" class="form-select" required>
                                                <option value="" selected disabled>Select an event</option>
                                                @foreach($upcomingEvents as $event)
                                                <option value="{{ $event->id }}">
                                                    {{ $event->title }} ({{ $event->start_date->format('M d') }})
                                                </option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Full Name</label>
                                            <input type="text" name="name" class="form-control" required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Email</label>
                                            <input type="email" name="email" class="form-control" required>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Organization (if applicable)</label>
                                            <input type="text" name="organization" class="form-control">
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Attending as</label>
                                            <select name="attending_as" class="form-select" required>
                                                <option value="" selected disabled>Select your role</option>
                                                <option value="Individual Citizen">Individual Citizen</option>
                                                <option value="Business Representative">Business Representative</option>
                                                <option value="NGO/Civil Society">NGO/Civil Society</option>
                                                <option value="Government Official">Government Official</option>
                                                <option value="Legal Professional">Legal Professional</option>
                                                <option value="Academic/Researcher">Academic/Researcher</option>
                                                <option value="Media">Media</option>
                                            </select>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Special Requirements</label>
                                            <textarea name="requirements" class="form-control" rows="2" placeholder="Accessibility needs, dietary restrictions, etc."></textarea>
                                        </div>

                                        <button type="submit" class="btn btn-primary w-100">Register for Event</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials -->

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Support button functionality
        document.querySelectorAll('.support-event').forEach(button => {
            button.addEventListener('click', function() {
                const eventId = this.getAttribute('data-event-id');
                fetch(`/events/${eventId}/support`, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Content-Type': 'application/json',
                            'Accept': 'application/json'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // Update supporter count
                            const supporterElement = this.closest('.event-card').querySelector('.text-muted');
                            const currentCount = parseInt(supporterElement.textContent.match(/\d+/)[0]);
                            supporterElement.textContent = supporterElement.textContent.replace(/\d+/, currentCount + 1);

                            // Update button
                            this.textContent = "Supported ✓";
                            this.disabled = true;
                            this.classList.remove('btn-primary');
                            this.classList.add('btn-success');

                            alert('Thank you for supporting this event!');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert('An error occurred. Please try again.');
                    });
            });
        });

        // Form submission feedback
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function(e) {
                const submitBtn = this.querySelector('button[type="submit"]');
                if (submitBtn) {
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Processing...';
                }
            });
        });
    });
</script>
@endpush

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize all countdown timers
        document.querySelectorAll('.deadline-countdown').forEach(container => {
            const deadline = new Date(container.dataset.deadline);
            const timerElement = container.querySelector('.countdown-timer');
            const expiredText = container.dataset.expiredText || 'Deadline passed';

            // Update immediately
            updateTimer(timerElement, deadline, expiredText);

            // Update every second
            const interval = setInterval(() => {
                updateTimer(timerElement, deadline, expiredText);
            }, 1000);
        });

        function updateTimer(element, deadline, expiredText) {
            const now = new Date();

            // Check for invalid date
            if (isNaN(deadline.getTime())) {
                element.textContent = "Invalid deadline";
                return;
            }

            const diff = deadline - now;

            if (diff <= 0) {
                element.textContent = expiredText;
                element.classList.add('text-danger', 'fw-bold');
                return;
            }

            // Calculate time components
            const days = Math.floor(diff / (1000 * 60 * 60 * 24));
            const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((diff % (1000 * 60)) / 1000);

            // Format the countdown
            let countdownText = '';
            if (days > 0) countdownText += `${days}d `;
            if (hours > 0 || days > 0) countdownText += `${hours}h `;
            countdownText += `${minutes}m ${seconds}s`;

            // Apply styling based on urgency
            element.classList.remove('text-danger', 'text-warning', 'text-success');
            if (days < 1) {
                element.classList.add('text-danger');
            } else if (days < 3) {
                element.classList.add('text-warning');
            } else {
                element.classList.add('text-success');
            }

            element.textContent = countdownText;
        }
    });
</script>
@endpush

@push('styles')
<style>
    .deadline-countdown {
        font-weight: 500;
    }

    .deadline-date {
        font-size: 0.85em;
        margin-left: 4px;
    }
</style>
@endpush
@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Current poll countdown
        const pollCountdown = document.getElementById('poll-countdown');
        if (pollCountdown) {
            const endTime = new Date(pollCountdown.dataset.end);

            function updatePollCountdown() {
                const now = new Date();
                const diff = endTime - now;

                if (diff <= 0) {
                    pollCountdown.innerHTML = 'Poll closed';
                    return;
                }

                const days = Math.floor(diff / (1000 * 60 * 60 * 24));
                const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((diff % (1000 * 60)) / 1000);

                let countdownText = '';
                if (days > 0) countdownText += `${days}d `;
                countdownText += `${hours}h ${minutes}m ${seconds}s`;

                pollCountdown.textContent = countdownText;
            }

            updatePollCountdown();
            setInterval(updatePollCountdown, 1000);
        }

        // Color coding for poll options
        document.querySelectorAll('.poll-card').forEach(card => {
            const options = card.querySelectorAll('.progress-bar');
            const colors = ['#0d6efd', '#198754', '#ffc107', '#dc3545', '#6f42c1'];

            options.forEach((option, index) => {
                option.style.backgroundColor = colors[index % colors.length];
            });
        });
    });
</script>
@endpush

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Activate tab from session
        @if(session('active_tab'))
        const activeTab = "{{ session('active_tab') }}";
        const tabTrigger = document.querySelector(`#${activeTab}-tab`);
        if (tabTrigger) {
            new bootstrap.Tab(tabTrigger).show();
        }
        @endif

        // Auto-close alerts after 5 seconds
        setTimeout(() => {
            document.querySelectorAll('.alert').forEach(alert => {
                new bootstrap.Alert(alert).close();
            });
        }, 5000);
    });
</script>
@endpush

@push('styles')
<style>
    .poll-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        border-top: 3px solid #0d6efd;
    }

    .poll-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }

    .progress-bar {
        transition: width 1s ease-in-out;
    }
</style>
@endpush
@endsection