

<?php $__env->startSection('content'); ?>

<style>
    .mission-list {
        padding-left: 20px;
        margin-top: 15px;
    }

    .mission-list li {
        margin-bottom: 10px;
        position: relative;
        padding-left: 15px;
    }

    .mission-list li::before {
        content: "•";
        position: absolute;
        left: 0;
        color: #000;
        font-weight: bold;
    }

    .vision-list {
        list-style-type: none;
        padding-left: 0;
    }

    .vision-list li {
        margin-bottom: 15px;
        position: relative;
        padding-left: 30px;
    }

    .vision-list li::before {
        content: "✓";
        position: absolute;
        left: 0;
        color: #b8860b;
        font-weight: bold;
        font-size: 1.2em;
    }

    /* Slider Styles */
    .banner-slider {
        position: relative;
        height: 100vh;
        min-height: 650px;
    }

    .banner-slide {
        position: relative;
        height: 100vh;
        min-height: 650px;
        background-size: cover;
        background-position: center;
        display: flex;
        align-items: center;
    }

    .banner-slide::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
    }

    .banner-content {
        position: relative;
        z-index: 2;
        color: white;
        text-align: center;
        width: 100%;
    }

    .slider-controls {
        position: absolute;
        bottom: 30px;
        left: 0;
        right: 0;
        z-index: 10;
        display: flex;
        justify-content: center;
        gap: 10px;
    }

    .slider-dot {
        width: 12px;
        height: 12px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.5);
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .slider-dot.active {
        background: #fff;
        transform: scale(1.2);
    }

    .slider-arrows {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        width: 100%;
        display: flex;
        justify-content: space-between;
        padding: 0 20px;
        z-index: 10;
    }

    .slider-arrow {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background: rgba(0, 0, 0, 0.3);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 24px;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .slider-arrow:hover {
        background: rgba(0, 0, 0, 0.7);
    }
</style>


<!-- Slider Banner -->
<!-- <div class="banner-slider owl-carousel">
    <?php $__currentLoopData = $sliderImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="banner-slide" style="background-image: url('<?php echo e(asset('storage/' . $image)); ?>');">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-7 col-md-12 text-center">
                    <div class="banner-content">
                        <h5>
                            <div class="icon">
                                <?php if($loop->index == 0): ?>
                                <i class="flaticon-courthouse"></i>
                                <?php elseif($loop->index == 1): ?>
                                <i class="flaticon-balance"></i>
                                <?php else: ?>
                                <i class="flaticon-mace"></i>
                                <?php endif; ?>
                            </div>
                            <?php if($loop->index == 0): ?>
                            Lagos State Law Reform
                            <?php elseif($loop->index == 1): ?>
                            Justice For All
                            <?php else: ?>
                            Legal Excellence
                            <?php endif; ?>
                        </h5>
                        <h3>
                            <?php if($loop->index == 0): ?>
                            Promoting Justice <span>Through Law Reform</span>
                            <?php elseif($loop->index == 1): ?>
                            Modernizing Legal Systems <span>For a Fair Society</span>
                            <?php else: ?>
                            Shaping the Future <span>of Lagos Justice System</span>
                            <?php endif; ?>
                        </h3>
                        <a href="<?php if($loop->index == 0): ?><?php echo e(route('about')); ?><?php elseif($loop->index == 1): ?><?php echo e(route('projects.index')); ?><?php else: ?><?php echo e(route('publications.index')); ?><?php endif; ?>"
                            class="button-3">
                            <?php if($loop->index == 0): ?>
                            About Our Commission
                            <?php elseif($loop->index == 1): ?>
                            Our Reform Projects
                            <?php else: ?>
                            Our Publications
                            <?php endif; ?>
                            <span></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div> -->


<!-- Slider Banner -->
<div class="banner-slider owl-carousel">
    <?php $__currentLoopData = $sliderImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="banner-slide" style="background-image: url('<?php echo e(Storage::url($image)); ?>');">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-lg-7 col-md-12 text-center">
                    <div class="banner-content">
                        <h5 style="color: #fff;">
                            <div class="icon">
                                <?php if($index == 0): ?>
                                <i class="flaticon-courthouse"></i>
                                <?php elseif($index == 1): ?>
                                <i class="flaticon-balance"></i>
                                <?php else: ?>
                                <i class="flaticon-mace"></i>
                                <?php endif; ?>
                            </div>
                            <?php if($index == 0): ?>
                            Lagos State Law Reform
                            <?php elseif($index == 1): ?>
                            Justice For All
                            <?php else: ?>
                            Legal Excellence
                            <?php endif; ?>
                        </h5>
                        <h3 style="color: #fff;">
                            <?php if($index == 0): ?>
                            Promoting Justice <span>Through Law Reform</span>
                            <?php elseif($index == 1): ?>
                            Modernizing Legal Systems <span>For a Fair Society</span>
                            <?php else: ?>
                            Shaping the Future <span>of Lagos Justice System</span>
                            <?php endif; ?>
                        </h3>
                        <a href="<?php if($index == 0): ?><?php echo e(route('about')); ?><?php elseif($index == 1): ?><?php echo e(route('projects.index')); ?><?php else: ?><?php echo e(route('publications.index')); ?><?php endif; ?>"
                            class="button-3">
                            <?php if($index == 0): ?>
                            About Our Commission
                            <?php elseif($index == 1): ?>
                            Our Reform Projects
                            <?php else: ?>
                            Our Publications
                            <?php endif; ?>
                            <span></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>


<!-- About -->
<section class="about section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-5 col-md-12 mb-30 animate-box" data-animate-effect="fadeInUp">
                <div class="section-subtitle">
                    <div class="icon"><i class="flaticon-courthouse"></i></div> About LAWRECOM
                </div>
                <p>The Lagos State Law Reform Commission (LAWRECOM) is the cornerstone agency for legal reform in Lagos State. We're committed to shaping a modern, forward-thinking legal framework that evolves with global standards and reflects the changing needs of our diverse society. Our goal is to create a more just, accessible, and effective legal system for all citizens.</p>
                <a href="<?php echo e(route('about')); ?>" class="button-2">Discover more<span></span></a>
            </div>
            <div class="col-lg-6 offset-lg-1 col-md-12 animate-box" data-animate-effect="fadeInUp">
                <div class="item">
                    <img src="<?php echo e(asset('storage/' . $siteSettings->about_banner)); ?>" class="img-fluid" alt="About LAWRECOM">
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Mandate Section -->
<section class="about section-padding bg-light">
    <div class="container">
        <div class="row">
            <div class="col-lg-5 col-md-12 mb-30 animate-box" data-animate-effect="fadeInUp">
                <img src="https://media.licdn.com/dms/image/v2/D4D12AQHQPIGp9_ByCA/article-cover_image-shrink_720_1280/article-cover_image-shrink_720_1280/0/1694513473735?e=2147483647&v=beta&t=JSoCNtvadHwcjzBzLhNBAs-CUXeqWVyStE4pxJzpLqE" class="img-fluid" alt="Law Reform">
            </div>
            <div class="col-lg-6 offset-lg-1 col-md-12 animate-box" data-animate-effect="fadeInUp">
                <div class="section-subtitle">
                    <div class="icon"><i class="flaticon-balance"></i></div> Our Mandate
                </div>
                <p>We proactively modernize and harmonize Lagos State laws by:</p>
                <ul class="mission-list">
                    <li>Reviewing outdated legislation and recommending reforms</li>
                    <li>Proposing new laws reflecting societal evolution and technological advancement</li>
                    <li>Ensuring justice, accessibility, and good governance for all</li>
                </ul>

                <div class="mt-4">
                    <p>We're building a more inclusive, just, and forward-thinking legal system through:</p>
                    <ul class="mission-list">
                        <li>Systematic reviews to identify gaps and inconsistencies</li>
                        <li>Repealing obsolete and redundant statutes</li>
                        <li>Simplifying legal texts for clarity and accessibility</li>
                        <li>Ensuring responsiveness to socio-economic and technological changes</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- Case Study Box -->
<section class="case-study-box">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 col-md-12 animate-box" data-animate-effect="fadeInUp">
                <div class="item"> <i class="icon flaticon-mace"></i>
                    <div class="cont">
                        <h5>Legislative Review</h5>
                        <p>Comprehensive examination of existing laws to identify needed reforms.</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-12 animate-box" data-animate-effect="fadeInUp">
                <div class="item"> <i class="icon flaticon-balance"></i>
                    <div class="cont">
                        <h5>Stakeholder Engagement</h5>
                        <p>Consulting with legal experts and civil society organizations.</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-12 animate-box" data-animate-effect="fadeInUp">
                <div class="item"> <i class="icon flaticon-mortarboard"></i>
                    <div class="cont">
                        <h5>Draft Legislation</h5>
                        <p>Preparing modernized bills for legislative consideration.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="about section-padding">
    <div class="container">
        <div class="row">
            <div class="section-title"><span>Our Vision</span></div>
            <ul class="page-list list-unstyled mb-25">
                <li>
                    <div class="page-list-icon"> <span class="ti-check"></span> </div>
                    <div class="page-list-text">
                        <p>To be a trailblazing institution advancing justice and equity through legal framework enhancement</p>
                    </div>
                </li>
                <li>
                    <div class="page-list-icon"> <span class="ti-check"></span> </div>
                    <div class="page-list-text">
                        <p>To be a premier institution driving transformative legal reforms for a dynamic society</p>
                    </div>
                </li>
                <li>
                    <div class="page-list-icon"> <span class="ti-check"></span> </div>
                    <div class="page-list-text">
                        <p>To foster a just and equitable society through continuous system improvement</p>
                    </div>
                </li>
                <li>
                    <div class="page-list-icon"> <span class="ti-check"></span> </div>
                    <div class="page-list-text">
                        <p>To shape a fairer future by leading impactful reforms that empower communities</p>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</section>

<!-- Mission Section -->
<section class="about section-padding bg-darkbrown">
    <div class="container">
        <div class="row justify-content-center align-items-center">
            <div class="col-lg-5 col-md-12 animate-box" data-animate-effect="fadeInLeft">
                <img class="img" src="<?php echo e(asset('storage/' . $siteSettings->mission_banner)); ?>" alt="Our Mission">
            </div>
            <div class="col-lg-5 offset-lg-1 col-md-12 animate-box" data-animate-effect="fadeInRight">
                <div class="section-title white">Our Mission</div>
                <div class="text-white">
                    <p>We revolutionize Lagos State's legal framework through rigorous research, dynamic stakeholder engagement, and bold reforms that advance justice, fairness, and effective governance. We're dedicated to crafting an inclusive legal system that fosters social equity and ensures a resilient foundation for sustainable development.</p>

                    <p class="mt-3">At LAWRECOM, we ignite positive change by transforming Lagos State's legal landscape. We're committed to fostering a transparent, accessible, and equitable justice system. Through relentless reform and innovation, we craft laws that promote inclusivity, societal growth, and alignment with global standards.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Team -->
<section class="team section-padding">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center mb-20">
                <div class="section-subtitle">
                    <div class="icon"><i class="flaticon-courthouse"></i></div>
                    <div class="section-title">Meet Our <span>Board Members</span></div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="owl-carousel owl-theme">
                    <?php $__currentLoopData = $teamMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="item">
                        <div class="img">
                            <img src="<?php echo e(asset('storage/' . $member->image)); ?>" alt="<?php echo e($member->name); ?>" class="img-cover">
                            <div class="social-icons">
                                <?php if($member->facebook): ?>
                                <a href="<?php echo e($member->facebook); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
                                <?php endif; ?>
                                <?php if($member->twitter): ?>
                                <a href="<?php echo e($member->twitter); ?>" target="_blank"><i class="fab fa-x-twitter"></i></a>
                                <?php endif; ?>
                                <?php if($member->instagram): ?>
                                <a href="<?php echo e($member->instagram); ?>" target="_blank"><i class="fab fa-instagram"></i></a>
                                <?php endif; ?>
                                <?php if($member->linkedin): ?>
                                <a href="<?php echo e($member->linkedin); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="info">
                            <h5><a href="#"><?php echo e($member->name); ?></a></h5>
                            <p><?php echo e($member->role); ?></p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Blog -->
<section class="blog section-padding bg-lightbrown">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center mb-20">
                <div class="section-subtitle">
                    <div class="icon"><i class="flaticon-courthouse"></i></div>
                    <div class="section-title">Latest News</div>
                </div>
            </div>
        </div>
        <div class="row">
            <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 col-md-6 d-flex">
                <div class="item mt-10 mb-30 w-100">
                    <div class="img">
                        <a href="<?php echo e(route('news.show', $item->id)); ?>">
                            <?php if($item->images && count($item->images) > 0): ?>
                            <img src="<?php echo e(asset('storage/'.$item->images[0])); ?>" class="img-fluid" alt="<?php echo e($item->title); ?>">
                            <?php endif; ?>
                            <div class="cat"><?php echo e($item->category->name ?? 'General'); ?></div>
                        </a>
                    </div>
                    <div class="cont">
                        <h4><a href="<?php echo e(route('news.show', $item->id)); ?>"><?php echo Str::limit(strip_tags($item->title), 50); ?></a></h4>
                        <p><?php echo Str::limit(strip_tags($item->content), 100); ?></p>
                        <div class="author">
                            <div>
                                <h5><?php echo e($item->created_at->format('d M Y')); ?></h5>
                                <h5>by <a href="#" class="text-decoration-line-bottom"><?php echo e($item->user->name ?? 'Admin'); ?></a></h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<?php $__env->startSection('scripts'); ?>
<script>
    // Initialize team carousel
    $('.team .owl-carousel').owlCarousel({
        loop: false,
        items: 3,
        margin: 30,
        nav: true,
        dots: false,
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 2
            },
            1000: {
                items: 3
            }
        }
    });

    // Initialize banner slider
    $('.banner-slider').owlCarousel({
        items: 1,
        loop: true,
        autoplay: true,
        autoplayTimeout: 3000,
        autoplayHoverPause: true,
        nav: false,
        dots: false,
        animateOut: 'fadeOut',
        animateIn: 'fadeIn',
        touchDrag: true,
        mouseDrag: true
    });

    // Add navigation arrows functionality
    $('.slider-arrow.prev').click(function() {
        $('.banner-slider').trigger('prev.owl.carousel');
    });

    $('.slider-arrow.next').click(function() {
        $('.banner-slider').trigger('next.owl.carousel');
    });

    // Add dot indicators functionality
    $('.slider-dot').click(function() {
        var index = $(this).index();
        $('.banner-slider').trigger('to.owl.carousel', [index, 300]);
    });

    // Update active dot on slide change
    $('.banner-slider').on('changed.owl.carousel', function(event) {
        var current = event.item.index;
        $('.slider-dot').removeClass('active').eq(current).addClass('active');
    });
</script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Sellie Deals\Documents\lawreform\resources\views/home.blade.php ENDPATH**/ ?>