<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- SEO Meta Tags -->
    <title><?php echo $__env->yieldContent('title', $siteSettings->site_name); ?></title>
    <meta name="description" content="<?php echo $__env->yieldContent('description', 'We are building a more inclusive, just, and forward-thinking legal system. One reform at a time. We are dedicated to: Conducting systematic reviews of existing laws to identify gaps, inconsistencies, and areas in need of reform. Repealing obsolete and redundant statutes to maintain a relevant legal framework.'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('keywords', 'news, updates, media, law reform, publication'); ?>">

    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="<?php echo $__env->yieldContent('og_title', $siteSettings->site_name); ?>">
    <meta property="og:description" content="<?php echo $__env->yieldContent('og_description', 'We are building a more inclusive, just, and forward-thinking legal system. One reform at a time. We are dedicated to: Conducting systematic reviews of existing laws to identify gaps, inconsistencies, and areas in need of reform. Repealing obsolete and redundant statutes to maintain a relevant legal framework.'); ?>">
    <meta property="og:image" content="<?php echo $__env->yieldContent('og_image', asset('img/default-og-image.jpg')); ?>">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:type" content="<?php echo $__env->yieldContent('og_type', 'website'); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset('img/favicon.png')); ?>" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Jost:ital,wght@0,100..900;1,100..900&amp;family=Playfair+Display:ital,wght@0,400..900;1,400..900&amp;display=swap">
    <link rel="stylesheet" href="<?php echo e(asset('css/plugins.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Add Laravel CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        .hover-shadow:hover {
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            transform: translateY(-3px);
        }

        .transition {
            transition: all 0.3s ease-in-out;
        }
    </style>
</head>

<body>
    <?php echo $__env->make('partials.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <?php echo $__env->make('partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="<?php echo e(asset('js/jquery-migrate-3.0.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/modernizr-2.6.2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/imagesloaded.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.isotope.v3.0.2.js')); ?>"></script>
    <script src="<?php echo e(asset('js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/scrollIt.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.stellar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.magnific-popup.js')); ?>"></script>
    <script src="<?php echo e(asset('js/YouTubePopUp.js')); ?>"></script>
    <script src="<?php echo e(asset('js/smooth-scroll.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/custom.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

    <!-- <?php echo $__env->yieldPushContent('scripts'); ?> -->
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html><?php /**PATH C:\Users\Sellie Deals\Documents\lawreform\resources\views/layouts/app.blade.php ENDPATH**/ ?>